#!/usr/bin/env python3
# -*- coding: utf-8 -*-


from math import sin, degrees, pi, radians
from datetime import datetime, timedelta
import matplotlib.pyplot as plt
import locale
import numpy as np
locale.setlocale(locale.LC_ALL, 'fr_FR.UTF-8')  # dates en français

plt.rcParams["lines.linewidth"] = 0.6
plt.rcParams["font.family"] = 'Linux Libertine O'
plt.rcParams["font.size"] = 6
R = 19.5
annee = 2026

#  longueurs des segments :
longueur0 = 0.12
longueur1 = 0.2
longueur5 = 0.2
longueur10 = 0.2

# def Rot(x, y, r):
#   return cos(r)*x + sin(r)*y, -sin(r)*x + cos(r)*y

def ephe(j):
    """
    j : date au format datetime.
    renvoie la longitude écliptique vraie du Soleil pour la date donnée,
    en radians.
    """
    km = 0.017202                           # vitesse angulaire de la l'anomalie en rd/j
    kl = 0.01720279                         # Vitesse angulaire de la longitude en rd/j
    jm = datetime(2021, 1, 3, 11, 2, 24)    # Date où l’anomalie est nulle
    jl = datetime(2020, 3, 22, 1, 1, 55)    # Date où la longitude moyenne est nulle
    e = 0.0167                              # Exentricité
    # Anomalie et longitude moyenne
    anom = (j - jm).total_seconds()/86400*km
    l = (j - jl).total_seconds()/86400*kl
    # Longitude écliptique vraie
    s = l + 2*e*sin(anom) + 1.25*e*e*sin(2*anom)
    return s

def trait(angle, longueur):
    """
    trace un trait de graduations de la longueur donnée.
    """
    ax.plot([angle,angle],[R,R-longueur], c='k')

def arc(angle1, angle2):
    theta = np.arange(angle1, angle2, 0.01)
    rayon = np.ones_like(theta) * R
    ax.plot(theta, rayon, c='sienna', lw=2, solid_capstyle='butt')

def mois(m):
    """
    m : entier : quantième du mois.
    Trace les graduations d'un mois.
    """
    if m == 12:
        nbjours = 31
    else:
        nbjours = (datetime(annee, m+1, 1) - timedelta(days=1)).day
    # nom = datetime(annee, m, 1).strftime('%B')
    premier = datetime(annee, m, 1)
    anglepremier = ephe(premier)
    ax.plot([anglepremier, anglepremier],[R-0.4, R-0.9], c='sienna',
            lw=2)

    for numjour in range(1,nbjours+1):
        date = datetime(annee, m, numjour)
        trait(ephe(date), longueur0)
        ax.text(ephe(date), R-longueur0-0.12, numjour, rotation=degrees(ephe(date)),
                va='center',ha='center',)

    # for multcinq in range(5,nbjours+1, 5):
    #     date = datetime(annee, m, multcinq)
    #     trait(ephe(date), longueur5)

    # for jour in range(10,nbjours+1, 10):
    #     j = datetime(annee, m, jour)
    #     trait(ephe(j), longueur10)
        # ax.text(ephe(j), R-longueur10-0.3, jour, rotation=degrees(ephe(j)),
        #         fontsize=5, va='center',ha='center',)

        # quatorze = ephe(datetime(2024, m, 14))
        # ax.text(quatorze, R-1.8, nom, rotation=-90+degrees(quatorze),
        #         va='center',ha='center',
        #         )

    # =============================================================================
# graphique
# =============================================================================
inch = 2.54 # conversion des cm en pouces
fig_width = (2*R+0) / inch
fig_height = (2*R+0) / inch
marge_G = 0.0 / inch
largeur_axe = 2*R / inch
hauteur_axe = 2*R / inch
marge_D = fig_width-marge_G-largeur_axe
marge_B = 0.0 / inch
marge_H = fig_height-marge_B-hauteur_axe

fig = plt.figure(figsize=(fig_width, fig_height))

ax = plt.subplot(projection='polar')

ax.set_xticks([])
ax.set_yticks([])
ax.set_ylim(0,R)
# ax.set_axis_off()

ax.scatter(0,0, marker='+', lw=0.4, c='k')


for m in range(1,13):
    mois(m)

# mois(1)
# mois(2)
# mois(3)

# arc(0,pi/6)

# unjanv = datetime(annee,1,1)
# for i in range(0,10,2):
#     # print(i)
#     j1 = unjanv + timedelta(days=i)
#     j2 = unjanv + timedelta(days=i+1.14)
#     angle1 = ephe(j1)
#     angle2 = ephe(j2)
#     if i==1:
#         print(angle1, angle2)
#     arc(angle1, angle2)



# =============================================================================
#
# =============================================================================
plt.subplots_adjust(
    left = marge_G / fig_width,
    right = 1-marge_D/fig_width,
    bottom= marge_B / fig_height,
    top= 1 - marge_H / fig_height,
)

fig.savefig('calendrier.png')
# fig.savefig('calendrier.pdf')
fig.savefig('calendrier.svg', transparent=True)
