#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Créé le Sat Sep  6 22:07:53 2025

@auteur: david ALBERTO
(www.astrolabe-science.fr)
"""
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
# import calculs_astro as calc


plt.rcParams["font.family"] = "Linux Libertine O"
plt.rcParams["font.size"] = 6

Requateur = 21.25
eps = np.radians(23+26/60)
pi = np.pi
# =============================================================================
# FONCTIONS
# =============================================================================

def rayon_decl(decl):
    """
    decl : declinaison du Soleil (radians) : float
    Renvoie le rayon.
    """
    return Requateur * (1-decl/(pi/2))

def rayonedt(edt):
    return (R60-R30) / 16 * edt + R30

Rmax = rayon_decl(-eps)
hauteur = Requateur + Rmax  # hauteur du tracé (emprise verticale totale)
R30 = rayon_decl(np.radians(30))  # rayon max pour équation du temps
R60 = rayon_decl(np.radians(60))  # rayon min pour équation du temps

# =============================================================================
#  calculs déclinaison
# =============================================================================
AD1 = np.radians(np.arange(-90,90,0.01))
long1 = np.arctan2(np.tan(AD1), np.cos(eps))
decl1 = np.arcsin(np.sin(long1) * np.sin(eps))
R1 = rayon_decl(decl1)

AD2 = np.radians(np.arange(90.01,270,0.01))
long2 = np.arctan2(-np.tan(AD2), np.cos(eps))
decl2 = np.arcsin(np.sin(long2) * np.sin(eps))
R2 = rayon_decl(decl2)

AD = np.concatenate((AD1,AD2))

# =============================================================================
# import AD et équation du temps
# =============================================================================

df1 = pd.read_csv('AD_Soleil.csv', sep=';')
df2 = pd.read_csv('edt2026.csv', sep=";")

ADedt = np.radians(df1["RA (h)"] * 15 )

eqt = (df2["Instant du passage au méridien (heure)"] - 12.0) * 60

neg = np.where(eqt < 0, eqt, np.nan)
pos = np.where(eqt >= 0, eqt, np.nan)

eqt = np.abs(eqt)
Rneg = rayonedt(-neg)
Rpos = rayonedt(pos)
Redt = rayonedt(eqt)

    # =============================================================================
# graphique
# =============================================================================
inch = 2.54 # conversion des cm en pouces
fig_width = (2*Requateur+2) / inch
fig_height = (hauteur+1) / inch
marge_G = 1 / inch
largeur_axe = 2*Requateur / inch
hauteur_axe = 2*Requateur / inch
marge_D = fig_width-marge_G-largeur_axe
marge_B = 0.5 / inch
marge_H = fig_height-marge_B-hauteur_axe

# =============================================================================
#
# =============================================================================
fig = plt.figure(figsize=(fig_width, fig_height))

ax = plt.subplot(projection = 'polar')

ax.set(
       xticks=[],
       yticks=[],
       ylim=(0,rayon_decl(0)),
       )
ax.set_theta_zero_location("W")
ax.grid(visible=None)

ax.scatter(0,0, marker='+', lw=0.2)
ax.plot(AD1, R1, c='k', lw=.7, clip_on=False)
ax.plot(AD2, R2, c='k', lw=.7, clip_on=False)


#  rayon déclinaison 30
rt = np.ones_like(AD) * R30

# ax.plot(AD, rt, c='gray', lw=0.6)


#  abaque équuation du temps :
ax.plot(ADedt, Redt, lw=0.6, c='sienna')
# ax.plot(ADedt, Rpos, lw=0.6, c='sienna')
# ax.plot(ADedt, Rneg, lw=0.6, c='sienna', ls='--')

# =============================================================================
#
# 
# =============================================================================
plt.subplots_adjust(
    left = marge_G / fig_width,
    right = 1-marge_D/fig_width,
    bottom= marge_B / fig_height,
    top= 1 - marge_H / fig_height,
)



fig.savefig('../reproduction LaTeX/abaques.png', dpi=100)
fig.savefig('../reproduction LaTeX/abaques.svg',transparent=True)
