#-LOI de décroissance radioactive
import matplotlib.pyplot as plt
import numpy as np

plt.rcParams.update({
"font.family": "serif",
"font.serif": ["Lato"], # use latex default serif font
"font.sans-serif": [], # use a specific sans-serif font
})

#Paramètres initiaux
A0=2e4
Tdemi=40

#Réglages aspect du graphe :
plt.text(0, A0, r'$A_0$= %s' %(A0))
#plt.grid(True)#Grille du graphe
plt.axis([0, Tdemi*5, 0, 1.25*A0])
plt.xlabel('temps')
plt.ylabel('Activité')
plt.title('Loi de décroissance radioactive (demi-vie=%s)' %(Tdemi), fontsize=14)

t=np.linspace(0, Tdemi*5, 100000)
def A(t):
    return A0*np.exp(-np.log(2)*t/Tdemi)

plt.plot(t, A(t), lw=2)#tracé de la fonction exponentielle

#Lignes verticales et horizontales :
A=A0
for n in  range(1, 5):
    A=A/2
    plt.plot([n*Tdemi, n*Tdemi], [0, A], '--')
    plt.plot([n*Tdemi, 0], [A, A], '--')
    plt.text(n*Tdemi, A, A)

plt.show()
